--------------------------------------------------------------------------
-- Vjeba 1.
--------------------------------
-- Napravite pogled koji e dohvaati sve stupce i retke iz tablice Kategorija
CREATE VIEW v1 AS
SELECT * FROM Kategorija
GO
--------------------------------

--------------------------------
-- Vjeba 1a.
--------------------------------
-- Ispiite nazive kategorija, potkategorija i proizvoda (koristite kreirani pogled)
SELECT
	v1.Naziv as 'Kategorija',
	Potkategorija.Naziv as 'Potkategorija',
	Proizvod.Naziv as 'Proizvod'
FROM v1
RIGHT JOIN Potkategorija ON Potkategorija.KategorijaID = v1.IDKategorija
RIGHT JOIN Proizvod ON Proizvod.PotkategorijaID = Potkategorija.IDPotkategorija
GO
--------------------------------

--------------------------------
-- Vjeba 1b.
--------------------------------
-- Pomou pogleda umetnite kategoriju naziva Alarmi
INSERT INTO v1 (Naziv) VALUES ('Alarmi')
GO
--------------------------------

--------------------------------
-- Vjeba 1c.
--------------------------------
-- Pomou pogleda promijenite kategoriji Alarmi naziv u Aktivna zatita
UPDATE v1 SET Naziv = 'Aktivna zatita' WHERE Naziv = 'Alarmi'
GO
--------------------------------

--------------------------------
-- Vjeba 1d.
--------------------------------
-- Pomou pogleda obriite kategoriju Aktivna zatita
DELETE FROM v1 WHERE Naziv = 'Aktivna zatita'
GO
--------------------------------

--------------------------------
-- Vjeba 1e.
--------------------------------
-- Uklonite pogled
DROP VIEW v1
GO
--------------------------------

--------------------------------------------------------------------------
-- Vjeba 2.
--------------------------------
-- Napravite pogled koji e dohvaati naziv grada, naziv drave u kojoj se nalazi te sve 
-- podatke o kupcima koji im pripadaju (tablice Grad, Drzava, Kupac).
CREATE VIEW v2 AS
SELECT
	Drzava.Naziv as 'Drava',
	Grad.Naziv as 'Grad',
	Kupac.* 
FROM Kupac
LEFT JOIN Grad ON Kupac.GradID = Grad.IDGrad
LEFT JOIN Drzava ON Grad.DrzavaID = Drzava.IDDrzava
GO
-- provjera
SELECT * FROM v2
GO
--------------------------------

--------------------------------
-- Vjeba 2a.
--------------------------------
-- Probajte pomou pogleda umetnuti novi grad. to se dogodilo?
INSERT INTO v2 (Grad) VALUES ('Bedekovina')
GO
SELECT * FROM Grad
GO

--------------------------------

--------------------------------
-- Vjeba 2b.
--------------------------------
-- Probajte pomou pogleda umetnuti novu dravu. to se dogodilo?
INSERT INTO v2 (Drava) VALUES ('Uzbekistan')
GO
SELECT * FROM Drzava
GO
--------------------------------

--------------------------------
-- Vjeba 2c.
--------------------------------
-- Probajte pomou pogleda umetnuti novog kupca. to se dogodilo? Moete li vidjeti novododanog kupca kroz pogled? Postoji li on u tablici?
INSERT INTO v2 (Ime, Prezime) 
	VALUES ('Pero','Peri')
GO
SELECT * FROM Kupac
GO
SELECT * FROM v2
GO
--------------------------------

--------------------------------
-- Vjeba 2d.
--------------------------------
-- Uklonite pogled
DROP VIEW v2
GO
--------------------------------

--------------------------------------------------------------------------
-- Vjeba 3.
--------------------------------
-- Napravite pogled koji e dohvaati sve kreditne kartice koje su tipa Visa ili MasterCard (tablica KreditnaKastica)
CREATE VIEW v3 AS
SELECT * FROM KreditnaKartica WHERE Tip IN ('Visa', 'MasterCard')
GO
--------------------------------

--------------------------------
-- Vjeba 3a i 3b.
--------------------------------
-- Umetnite zapis o kreditnoj kartici tipa American Express.
-- Dohvatiti umetnuti redak pomou pogleda. to se dogodilo? Je li redak uspjeno umetnut u tablicu?
INSERT INTO v3 (Tip, Broj,IstekMjesec, IstekGodina) 
VALUES ('American Express', '111222333444', 12, 2012)
GO
SELECT * FROM v3 WHERE Tip = 'American Express'
GO

--------------------------------

--------------------------------
-- Vjeba 3c.
--------------------------------
-- Promijenite pogled tako da ne doputa umetanje/izmjenu redaka koji nee biti vidljivi kroz njega.
ALTER VIEW v3 AS
SELECT * FROM KreditnaKartica WHERE Tip IN ('Visa', 'MasterCard')
WITH CHECK OPTION
GO
INSERT INTO v3 (Tip, Broj,IstekMjesec, IstekGodina) 
VALUES ('American Express', '111222333444', 12, 2012)
GO
--------------------------------

--------------------------------
-- Vjeba 3d.
--------------------------------
-- Umetnite zapis o kreditnoj kartici tipa MasterCard. to se dogodilo? Je li redak uspjeno umetnut u tablicu?
INSERT INTO v3 (Tip, Broj,IstekMjesec, IstekGodina) 
VALUES ('MasterCard', '111222333444', 12, 2012)
GO
--------------------------------

--------------------------------
-- Vjeba 3e.
--------------------------------
-- Promijenite pogled tako da doputa umetanje/izmjenu redaka koji nee biti vidljivi kroz njega.
ALTER VIEW v3 AS
SELECT * FROM KreditnaKartica WHERE Tip IN ('Visa', 'MasterCard')
GO
--------------------------------

--------------------------------
-- Vjeba 3f.
--------------------------------
-- Uklonite pogled
DROP VIEW v3
GO
--------------------------------

-- Vjebe 4.
/*
Napravite tablicu Film sa stupcima IDFilm, Naziv, GodinaProizvodnje, TrajanjeMinuta i KratkiOpis. Umetnite koji redak. 
Napravite pogled koji dohvaa sve iz tablice Film
Iskoristite pogled za dohvaanje podataka
Uklonite stupac TrajanjeMinuta iz tablice
Iskoristite pogled za dohvaanje podataka
Promijenite pogled tako da bude vrsto vezan uz objekte koje koristi
Iskoristite pogled za dohvaanje podataka
Uklonite stupac GodinaProizvodnje iz tablice. Je li uklanjanje uspjelo? Zato?
Uklonite pogled i tablicu
*/
CREATE TABLE Film
(
	IDFilm int CONSTRAINT PK_Film PRIMARY KEY IDENTITY,
	Naziv nvarchar(200) NOT NULL,
	GodinaProizvodnje int NOT NULL,
	TrajanjeMinuta int NOT NULL,
	KratkiOpis nvarchar(max) NOT NULL
)
GO
INSERT INTO Film (Naziv, GodinaProizvodnje, TrajanjeMinuta, KratkiOpis) 
	VALUES (N'O makama i psima 2: Osveta Kitty Galore', 2010, 85, N'U vjenoj bitci maaka i pasa, jedna poludjela maka odvest e stvari jednu apu predaleko. Kitty Galore, biva agentica pijunske organizacije MIJAU, pobjegla je i skovala avolji plan u kojem ne samo da e pokuati pripitomiti svoje vjene neprijatelje, ve i svoje bive kolege make, ali i cjelokupno ovjeanstvo. Suoeni s ovom prijetnjom bez presedana, make i psi biti e prisiljeni prvi put u povijesti udruiti snage kako bi spasili sebe  ali i svoje vlasnike')
INSERT INTO Film (Naziv, GodinaProizvodnje, TrajanjeMinuta, KratkiOpis) 
	VALUES (N'Shrek uvijek i zauvijek', 2010, 95, N'Nakon to se borio s opakim zmajem, spasio prekrasnu princezu i oslobodio itavo kraljevstvo  kakav bi zadatak jo mogao postojati u ivotu slavnog Shreka? Odgovor je jasan: obitelj, odnosno svakodnevna bitka s malim nestanim Shrekiima. Meutim, sve e to biti kratka vijeka, jer e Shrek ubrzo upoznati lukavog Rumpelstiltskina i iznenada se nai u potpuno drugoj dimenziji, alternativnoj budunosti u kojoj se on i Fiona nikad nisu susreli, u kojoj je ba on ugroena vrsta, a Rumpelstiltskin kralj! Naravno, jedino je Shrek taj koji e moi ispraviti novonastalu situaciju, spasiti prijatelje, obnoviti kraljevstvo i ponovno pronai svoju pravu, jedinu ljubav.')
INSERT INTO Film (Naziv, GodinaProizvodnje, TrajanjeMinuta, KratkiOpis) 
	VALUES (N'Resident Evil: Drugi svijet', 2010, 90, N'Svijet je poharan virusnom infekcijom od koje oboljeli postaju zombiji. Alice (Milla Jovovich) pronalazi preivjele i spaava ih. Njezina bitka s Umbrella Corporation dostie smrtonosne razine, no u pomo joj priskae stari prijatelj. U nadi da e pronai sigurno mjesto odlaze prema Los Angelesu. No, grad je preplavljen tisuama zombija i oni e naletjeti u zamku')
GO

CREATE VIEW v4 AS
SELECT * FROM Film
GO

SELECT * FROM v4
GO

ALTER TABLE Film DROP COLUMN TrajanjeMinuta
GO

ALTER VIEW v4 
WITH SCHEMABINDING
AS
SELECT IDFilm, Naziv, GodinaProizvodnje, KratkiOpis FROM dbo.Film
GO

SELECT * FROM v4
GO

ALTER TABLE Film DROP COLUMN GodinaProizvodnje
GO

DROP VIEW v4
DROP TABLE Film
GO

-- Vjebe 5.
/*
Napravite pogled koji dohvaa 10 proizvoda koji su najvie prodavani. Stupci koje pogled vraa neka budu ID i naziv te ukupna koliina prodanih proizvoda.
Pogledajte SELECT upit pogleda kroz suelje i pomou sistemske procedure sp_helptext
Zatitite pogled
Pogledajte SELECT upit pogleda kroz suelje i pomou sistemske procedure sp_helptext
Promijenite pogled tako da bude zatien i vrsto vezan uz tablice
Promijenite pogled tako da bude zatien, vrsto vezan uz tablice i da ne doputa izmjene koje nee biti vidljive kroz pogled
Uklonite pogled
*/
CREATE VIEW v5 AS
SELECT TOP 10 
	Proizvod.IDProizvod AS 'ID',
	Proizvod.Naziv,
	SUM(Stavka.Kolicina) AS 'UkupnaKolicina'
FROM Proizvod
INNER JOIN Stavka ON Stavka.ProizvodID = Proizvod.IDProizvod
GROUP BY Proizvod.IDProizvod, Proizvod.Naziv
ORDER BY 3 DESC
GO

SELECT * FROM v5
GO

EXECUTE sp_helptext v5
GO

ALTER VIEW v5 
WITH ENCRYPTION
AS
SELECT TOP 10 
	Proizvod.IDProizvod AS 'ID',
	Proizvod.Naziv,
	SUM(Stavka.Kolicina) AS 'UkupnaKolicina'
FROM Proizvod
INNER JOIN Stavka ON Stavka.ProizvodID = Proizvod.IDProizvod
GROUP BY Proizvod.IDProizvod, Proizvod.Naziv
ORDER BY 3 DESC
GO

EXECUTE sp_helptext v5
GO

ALTER VIEW v5 
WITH ENCRYPTION, SCHEMABINDING
AS
SELECT TOP 10 
	dbo.Proizvod.IDProizvod AS 'ID',
	dbo.Proizvod.Naziv,
	SUM(dbo.Stavka.Kolicina) AS 'UkupnaKolicina'
FROM dbo.Proizvod
INNER JOIN dbo.Stavka ON dbo.Stavka.ProizvodID = dbo.Proizvod.IDProizvod
GROUP BY dbo.Proizvod.IDProizvod, dbo.Proizvod.Naziv
ORDER BY 3 DESC
GO

ALTER VIEW v5 
WITH ENCRYPTION, SCHEMABINDING
AS
SELECT TOP 10 
	dbo.Proizvod.IDProizvod AS 'ID',
	dbo.Proizvod.Naziv,
	SUM(dbo.Stavka.Kolicina) AS 'UkupnaKolicina'
FROM dbo.Proizvod
INNER JOIN dbo.Stavka ON dbo.Stavka.ProizvodID = dbo.Proizvod.IDProizvod
GROUP BY dbo.Proizvod.IDProizvod, dbo.Proizvod.Naziv
ORDER BY 3 DESC
WITH CHECK OPTION
GO

DROP VIEW v5
GO
